/*
 * Decompiled with CFR 0.152.
 */
package jp.netstar.servlet.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SameSiteCookieHeaderFilter
implements Filter {
    private ServletContext servletContext;
    private boolean enableLogging = true;
    private static final String SAMESITE_ATTRIBITE_NAME = "SameSite";
    private static final String SET_COOKIE = "Set-Cookie";
    private Map<String, SameSiteValue> sameSiteCookies = Collections.emptyMap();

    private void log(String message) {
        if (this.servletContext != null && message != null && this.enableLogging) {
            this.servletContext.log(message);
        }
    }

    private static String trimOrNull(String str) {
        String result = null;
        if (str != null && !(str = str.trim()).isEmpty()) {
            result = str;
        }
        return result;
    }

    public void setSameSiteCookies(Map<SameSiteValue, List<String>> map) {
        if (map != null) {
            this.sameSiteCookies = new HashMap<String, SameSiteValue>(4);
            for (Map.Entry<SameSiteValue, List<String>> entry : map.entrySet()) {
                for (String cookieName : entry.getValue()) {
                    if (this.sameSiteCookies.get(cookieName) != null) {
                        this.log(String.format("Duplicate cookie name [%s] found in SameSite cookie map, please check configuration.", cookieName));
                        throw new IllegalArgumentException("Duplicate cookie name found in SameSite cookie map");
                    }
                    String trimmedName = SameSiteCookieHeaderFilter.trimOrNull(cookieName);
                    if (trimmedName == null) continue;
                    this.sameSiteCookies.put(cookieName, entry.getKey());
                }
            }
        } else {
            this.sameSiteCookies = Collections.emptyMap();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        HashMap<SameSiteValue, List<String>> map = new HashMap<SameSiteValue, List<String>>();
        for (SameSiteValue aValue : SameSiteValue.values()) {
            String params = filterConfig.getInitParameter(aValue.name().toLowerCase());
            if (params == null) continue;
            map.put(aValue, SameSiteCookieHeaderFilter.splitString(params));
        }
        String enableLoggingStr = filterConfig.getInitParameter("log");
        if (enableLoggingStr != null) {
            this.enableLogging = Boolean.parseBoolean(enableLoggingStr);
        }
        if (!map.isEmpty()) {
            this.log("set SameSite cookies into filter.");
            this.setSameSiteCookies(map);
        }
        this.log("initialized SameSite Cookie Filter.");
    }

    private static List<String> splitString(String str) {
        String[] strArray = str.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String strItem : strArray) {
            result.add(strItem);
        }
        return result;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Request is not an instance of HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        HttpServletRequest httpReq = (HttpServletRequest)request;
        this.log(String.format("do filter in Samesite Cookie Filter on %s.", httpReq.getRequestURI()));
        chain.doFilter(request, (ServletResponse)new SameSiteResponseProxy((HttpServletResponse)response));
    }

    private class SameSiteResponseProxy
    extends HttpServletResponseWrapper {
        private final HttpServletResponse response;

        public SameSiteResponseProxy(HttpServletResponse resp) {
            super(resp);
            this.response = resp;
        }

        public void sendError(int sc) throws IOException {
            this.appendSameSite();
            super.sendError(sc);
        }

        public PrintWriter getWriter() throws IOException {
            this.appendSameSite();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.appendSameSite();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.appendSameSite();
            super.sendRedirect(location);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.appendSameSite();
            return super.getOutputStream();
        }

        private void appendSameSite() {
            Collection cookieheaders = this.response.getHeaders(SameSiteCookieHeaderFilter.SET_COOKIE);
            boolean firstHeader = true;
            for (String cookieHeader : cookieheaders) {
                if (SameSiteCookieHeaderFilter.trimOrNull(cookieHeader) == null) continue;
                List<HttpCookie> parsedCookies = null;
                try {
                    parsedCookies = HttpCookie.parse(cookieHeader);
                }
                catch (IllegalArgumentException e) {
                    SameSiteCookieHeaderFilter.this.log(String.format("Cookie header [%s] violates the cookie specification and will be ignored", cookieHeader));
                }
                if (parsedCookies == null || parsedCookies.size() != 1) continue;
                SameSiteValue sameSiteValue = (SameSiteValue)((Object)SameSiteCookieHeaderFilter.this.sameSiteCookies.get(parsedCookies.get(0).getName()));
                if (sameSiteValue != null) {
                    this.appendSameSiteAttribute(cookieHeader, sameSiteValue.getValue(), firstHeader);
                } else if (firstHeader) {
                    this.response.setHeader(SameSiteCookieHeaderFilter.SET_COOKIE, cookieHeader);
                } else {
                    this.response.addHeader(SameSiteCookieHeaderFilter.SET_COOKIE, cookieHeader);
                }
                firstHeader = false;
            }
        }

        private void appendSameSiteAttribute(String cookieHeader, String sameSiteValue, boolean first) {
            String sameSiteSetCookieValue = cookieHeader;
            if (!cookieHeader.contains(SameSiteCookieHeaderFilter.SAMESITE_ATTRIBITE_NAME)) {
                sameSiteSetCookieValue = String.format("%s; %s", cookieHeader, "SameSite=" + sameSiteValue);
            }
            if (first) {
                this.response.setHeader(SameSiteCookieHeaderFilter.SET_COOKIE, sameSiteSetCookieValue);
                return;
            }
            this.response.addHeader(SameSiteCookieHeaderFilter.SET_COOKIE, sameSiteSetCookieValue);
        }
    }

    public static enum SameSiteValue {
        Strict("Strict"),
        Lax("Lax"),
        None("None");

        private String value;

        private SameSiteValue(String attrValue) {
            this.value = attrValue;
        }

        public String getValue() {
            return this.value;
        }
    }
}

