#!/bin/sh

HTML_INFO="/www/update_fw_info.txt"
HTML_FW_SIZE_REMAIN="/www/fw_size_remain.js"
#if 1   // added by yjpark.
HTML_RESULT="/www/update_fw_result.txt"
#endif

FW_PATH="/dev/shm"
FW_BOOT="mtdblkboot"
FW_KERNEL="mtdblkkernel"
FW_ROOTFS="mtdblkrootfs"
#if 1   // added by yjpark.
FW_KERNEL_SLAVE="mtdblkkernelslave"
FW_ROOTFS_SLAVE="mtdblkrootfsslave"
#endif
FW_PATCH="mtdblkrootfsp"
#if 0   // blocked by mini for HOST.
#FW_LOGO="mtdblklogo"
#endif
FW_EDID="EDID.txt"
SYSFS_EDID="/sys/devices/platform/videoip/eeprom_content"
FILE_FLAGS="flags.sh"
FILE_THIS="flash.sh"

#if 1   // added by yjpark for old version compatibility (V10, V20), modified by mini.
BOOTM_JUMP=`astparam g bootm_jump`
PLATFORM_MISMATCH="Platform mismatch."
SOC_VERSION_MISMATCH="SoC version mismatch."
UNKNOWN_SOC_VERSION="Unknown SoC version."

# GET current model version.
UPDATE_CUR_FW_VERSION=`cat /.version`

# Get Firmware info: CUR_MODEL_NAME, MODEL_VERSION, MODEL_BUILD_DATE.
CUR_MODEL_NAME=`cat /.version | awk -F'_' '{print $1}'`
_MODEL_VERSION=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $2}'`

if echo "$_MODEL_VERSION" | grep -q "V" ; then
	MODEL_VERSION=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $2}'`
	MODEL_BUILD_DATE=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $3}' | awk -F'.' '{print $1}'`
else
	MODEL_VERSION=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $3}'`
	MODEL_BUILD_DATE=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $4}' | awk -F'.' '{print $1}'`
fi

html_info "Current model_name: $CUR_MODEL_NAME"
html_info "New model_version: $MODEL_VERSION"
html_info "New model_build_date: $MODEL_BUILD_DATE"

if [ -f "/dev/shm/.version" ]; then
	# The file(.version) exists in version V20 below.
	UPDATE_NEW_FW_VERSION=`cat /dev/shm/.version`
else
	UPDATE_NEW_FW_VERSION="$CUR_MODEL_NAME"_"$MODEL_VERSION"_"$MODEL_BUILD_DATE"
fi

CUR_FW_V10=`echo "$UPDATE_CUR_FW_VERSION" | grep "V10"`
NEW_FW_V10=`echo "$UPDATE_NEW_FW_VERSION" | grep "V10"`

writed_model_name_version_build_date()
{
	# Read RO Astparam.
	GET_RO_ASTPARAM_MODEL_NAME=`astparam r model_name`
	GET_RO_ASTPARAM_MODEL_VERSION=`astparam r model_version`
	GET_RO_ASTPARAM_MODEL_BUILD_DATE=`astparam r model_build_date`
	html_info "RO model_name: $GET_RO_ASTPARAM_MODEL_NAME"
	html_info "Old RO model_version: $GET_RO_ASTPARAM_MODEL_VERSION"
	html_info "Old RO model_build_date: $GET_RO_ASTPARAM_MODEL_BUILD_DATE"

	if echo "$CUR_MODEL_NAME" | grep -q "IPVDS-700-E" ||
	   echo "$CUR_MODEL_NAME" | grep -q "IPVDS-710-E" ||
	   echo "$CUR_MODEL_NAME" | grep -q "S600-OP-E"; then
		html_info "CUR_MODEL_NAME: $CUR_MODEL_NAME"
	else
		html_info "Write a model_name not matched $CUR_MODEL_NAME"
	fi
	astparam w model_name $CUR_MODEL_NAME

	html_info "New RO model_version: $MODEL_VERSION"
	html_info "New RO model_build_date: $MODEL_BUILD_DATE"
	astparam w model_version $MODEL_VERSION
	astparam w model_build_date $MODEL_BUILD_DATE
	astparam save ro
}

added_V21_restore_astparam()
{
	RESTORE_S0_BAUDRATE=`astparam g s0_baudrate`
	if echo "$RESTORE_S0_BAUDRATE" | grep -q "not defined" ; then
		RESTORE_S0_BAUDRATE=""
	fi

	RESTORE_V_ENG_DRV_OPTION=`astparam g v_eng_drv_option`
	if echo "$RESTORE_V_ENG_DRV_OPTION" | grep -q "not defined" ; then
		RESTORE_V_ENG_DRV_OPTION=""
	fi
}

added_V21_set_save_astparam()
{
	astparam s s0_baudrate $RESTORE_S0_BAUDRATE
	astparam s v_eng_drv_option $RESTORE_V_ENG_DRV_OPTION
}

added_V22_restore_astparam()
{
	if echo "$CUR_MODEL_NAME" | grep -q "IPVDS-710-E"; then
		RESTORE_KVM_GROUP_NAME=`astparam g kvm_group_name`
		if echo "$RESTORE_KVM_GROUP_NAME" | grep -q "not defined" ; then
			RESTORE_KVM_GROUP_NAME=""
		fi

		RESTORE_KVM_GROUP_ORDER=`astparam g kvm_group_order`
		if echo "$RESTORE_KVM_GROUP_ORDER" | grep -q "not defined" ; then
			RESTORE_KVM_GROUP_NAME=""
		fi

		RESTORE_KVM_GROUP_MAX=`astparam g kvm_group_max`
		if echo "$RESTORE_KVM_GROUP_MAX" | grep -q "not defined" ; then
			RESTORE_KVM_GROUP_MAX=""
		fi
	fi
}

added_V22_set_save_astparam()
{
	if echo "$CUR_MODEL_NAME" | grep -q "IPVDS-710-E"; then
		astparam s kvm_group_name $RESTORE_KVM_GROUP_NAME
		astparam s kvm_group_order $RESTORE_KVM_GROUP_ORDER
		astparam s kvm_group_max $RESTORE_KVM_GROUP_MAX
	fi
}

common_restore_astparam()
{
	RESTORE_SERIAL_NUMBER=`astparam g serial_number`
	RESTORE_ETHADDR=`astparam g ethaddr`
	RESTORE_IP_MODE=`astparam g ip_mode`
	RESTORE_IPADDR=`astparam g ipaddr`
	RESTORE_NETMASK=`astparam g netmask`
	RESTORE_GATEWAYIP=`astparam g gatewayip`
	RESTORE_HOSTNAME_ID=`astparam g hostname_id`
	RESTORE_JUMBO_MTU=`astparam g jumbo_mtu`
	RESTORE_PROFILE=`astparam g profile`
	RESTORE_AST_VIDEO_QUALITY_MODE=`astparam g ast_video_quality_mode`
}

common_set_save_astparam()
{
	astparam s multicast_on y
	astparam s en_video_wall y
	astparam s hostnamebydipswitch n
	astparam s hdcp_always_on y
	astparam s web_ui_cfg nevwausr
	astparam s a_io_select auto
	astparam s v_input_select fixed
	astparam s v_bcd_threshold 1
	astparam s reset_ch_on_boot y
	astparam s restart_ch_on_boot y

	astparam s serial_number $RESTORE_SERIAL_NUMBER
	astparam s ethaddr $RESTORE_ETHADDR
	astparam s ip_mode $RESTORE_IP_MODE
	astparam s ipaddr $RESTORE_IPADDR
	astparam s netmask $RESTORE_NETMASK
	astparam s gatewayip $RESTORE_GATEWAYIP
	astparam s hostname_id $RESTORE_HOSTNAME_ID
	astparam s jumbo_mtu $RESTORE_JUMBO_MTU
	astparam s profile $RESTORE_PROFILE
	astparam s ast_video_quality_mode $RESTORE_AST_VIDEO_QUALITY_MODE
}

update_from_V20_or_higher_to_v14_restore_astparam()
{
	common_restore_astparam

#if 1   // V1.4 default
	RESTORE_HPD_IGNORE='n'
	RESTORE_HPD_SLEEP_TIME='0'
	RESTORE_TMDS_DISABLE='n'
	RESTORE_FORCE_DVI_OR_HDMI='hdmi'
	RESTORE_SHARE_USB_AUTO_MODE='n'
	RESTORE_NO_USB='n'
	RESTORE_NO_KMOIP='y'
	RESTORE_NO_IR='y'
	RESTORE_BLOCKING='n'
#endif

#if 1   // convert V2.0 to V1.4
	# V2.0 = rs232_port_selection
	# V1.4 = serial_debug_sel
	RESTORE_RS232_PORT_SELECTION=`astparam g rs232_port_selection`
	if echo "$RESTORE_RS232_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=""
	fi

	# V2.0 = ir_port_selection
	# V1.4 = ir_tx_rx_sel
	RESTORE_IR_PORT_SELECTION=`astparam g ir_port_selection`
	if echo "$RESTORE_IR_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=""
	fi
#endif
}

update_from_V20_or_higher_to_v14_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

#if 1   // V1.4 default
	astparam s hpd_ignore $RESTORE_HPD_IGNORE
	astparam s hpd_sleep_time $RESTORE_HPD_SLEEP_TIME
	astparam s tmds_disable $RESTORE_TMDS_DISABLE
	astparam s force_dvi_or_hdmi $RESTORE_FORCE_DVI_OR_HDMI
	astparam s share_usb_auto_mode $RESTORE_SHARE_USB_AUTO_MODE
	astparam s no_usb $RESTORE_NO_USB
	astparam s no_kmoip $RESTORE_NO_KMOIP
	astparam s no_ir $RESTORE_NO_IR
	astparam s blocking $RESTORE_BLOCKING
#endif

#if 1   // convert V2.0 to V1.4
	# V2.0 = rs232_port_selection
	# V1.4 = serial_debug_sel
	astparam s serial_debug_sel $RESTORE_RS232_PORT_SELECTION

	# V2.0 = ir_port_selection
	# V1.4 = ir_tx_rx_sel
	astparam s ir_tx_rx_sel $RESTORE_IR_PORT_SELECTION
#endif

	astparam save
	sync
}

update_from_V20_or_higher_to_v15_restore_astparam()
{
	common_restore_astparam

	RESTORE_RS232_PORT_SELECTION=`astparam g rs232_port_selection`
	if echo "$RESTORE_RS232_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=""
	fi

	RESTORE_IR_PORT_SELECTION=`astparam g ir_port_selection`
	if echo "$RESTORE_IR_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=""
	fi

#if 1   // V1.5 default
	RESTORE_ENABLE_HPD='y'
	RESTORE_DELAY_AFTER_HPD='0'
	RESTORE_RESET_TMDS_AFTER_HPD='n'
	RESTORE_LOCAL_DISPLAY_VIDEO_MODE='hdmi'
	RESTORE_SHARE_USB_AUTO_MODE='n'
	RESTORE_NO_USB='n'
	RESTORE_NO_KMOIP='y'
	RESTORE_NO_IR='y'
	RESTORE_BLOCKING='n'
	RESTORE_PREVIEW_FRAMERATE='middle'
#endif
}

update_from_V20_or_higher_to_v15_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

	astparam s rs232_port_selection $RESTORE_RS232_PORT_SELECTION
	astparam s ir_port_selection $RESTORE_IR_PORT_SELECTION

#if 1   // V1.5 default
	astparams s enable_hpd $RESTORE_ENABLE_HPD
	astparams s delay_after_hpd $RESTORE_DELAY_AFTER_HPD
	astparams s reset_tmds_after_hpd $RESTORE_RESET_TMDS_AFTER_HPD
	astparams s local_display_video_mode $RESTORE_LOCAL_DISPLAY_VIDEO_MODE
	astparams s share_usb_auto_mode $RESTORE_SHARE_USB_AUTO_MODE
	astparams s no_usb $RESTORE_NO_USB
	astparams s no_kmoip $RESTORE_NO_KMOIP
	astparams s no_ir $RESTORE_NO_IR
	astparams s blocking $RESTORE_BLOCKING
	astparams s preview_framerate $RESTORE_PREVIEW_FRAMERATE
#endif

	astparam save
	sync
}

update_from_v14_v15_to_higher_than_v20_restore_astparam()
{
	common_restore_astparam
	added_V21_restore_astparam
	added_V22_restore_astparam

#if 1   // V2.0 default
	RESTORE_ENABLE_SNAPSHOT='y'
#endif

#if 1   // convert V1.4 or V1.5 to V2.0
	RS232_PORT_SELECTION_V1_5=`astparam g rs232_port_selection`
	RS232_PORT_SELECTION_V1_4=`astparam g serial_debug_sel`
	if echo "$RS232_PORT_SELECTION_V1_5" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=$RS232_PORT_SELECTION_V1_4
	else
		RESTORE_RS232_PORT_SELECTION=$RS232_PORT_SELECTION_V1_5
	fi

	IR_PORT_SELECTION_V1_5=`astparam g ir_port_selection`
	IR_PORT_SELECTION_V1_4=`astparam g ir_tx_rx_sel`
	if echo "$IR_PORT_SELECTION_V1_5" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=$IR_PORT_SELECTION_V1_4
	else
		RESTORE_IR_PORT_SELECTION=$IR_PORT_SELECTION_V1_5
	fi
#endif
}

update_from_v14_v15_to_higher_than_v20_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

#if 1   // V2.0 default
	astparam s enable_snapshot $RESTORE_ENABLE_SNAPSHOT
#endif

#if 1   // V2.0 default
	astparam s rs232_port_selection $RESTORE_RS232_PORT_SELECTION
	astparam s ir_port_selection $RESTORE_IR_PORT_SELECTION
#endif

	added_V21_set_save_astparam
	added_V22_set_save_astparam

	astparam save
	sync
}

update_to_higher_version_than_v20_restore_astparam()
{
	common_restore_astparam
	added_V21_restore_astparam
	added_V22_restore_astparam

	RESTORE_TELNET=`astparam g telnetd_param`
	if echo "$RESTORE_TELNET" | grep -q "not defined" ; then
		RESTORE_TELNET=""
	fi

	RESTORE_RS232_PORT_SELECTION=`astparam g rs232_port_selection`
	if echo "$RESTORE_RS232_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=""
	fi

	RESTORE_IR_PORT_SELECTION=`astparam g ir_port_selection`
	if echo "$RESTORE_IR_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=""
	fi

	RESTORE_ENABLE_SNAPSHOT=`astparam g enable_snapshot`
	if echo "$RESTORE_ENABLE_SNAPSHOT" | grep -q "not defined" ; then
		RESTORE_ENABLE_SNAPSHOT=""
	fi

	RESTORE_FAST_SNAPSHOT=`astparam g fast_snapshot`
	if echo "$RESTORE_FAST_SNAPSHOT" | grep -q "not defined" ; then
		RESTORE_FAST_SNAPSHOT=""
	fi

	RESTORE_SNAPSHOT_PIXEL_WIDTH=`astparam g snapshot_pixel_width`
	if echo "$RESTORE_SNAPSHOT_PIXEL_WIDTH" | grep -q "not defined" ; then
		RESTORE_SNAPSHOT_PIXEL_WIDTH=""
	fi
}

update_to_higher_version_than_v20_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

	astparam s telnetd_param $RESTORE_TELNET
	astparam s rs232_port_selection $RESTORE_RS232_PORT_SELECTION
	astparam s ir_port_selection $RESTORE_IR_PORT_SELECTION

	astparam s enable_snapshot $RESTORE_ENABLE_SNAPSHOT
	astparam s fast_snapshot $RESTORE_FAST_SNAPSHOT
	astparam s snapshot_pixel_width $RESTORE_SNAPSHOT_PIXEL_WIDTH

	added_V21_set_save_astparam
	added_V22_set_save_astparam

	astparam save
	sync
}
#endif

total_fw_size()
{
	fsize='0'
	if [ -f "$FW_PATH/$FW_BOOT" ]; then
		set -- `ls -l $FW_PATH/$FW_BOOT`
		#echo "$FW_BOOT size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_KERNEL" ]; then
		set -- `ls -l $FW_PATH/$FW_KERNEL`
		#echo "$FW_KERNEL size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_ROOTFS" ]; then
		set -- `ls -l $FW_PATH/$FW_ROOTFS`
		#echo "$FW_ROOTFS size $5 B"
		fsize=`expr $fsize + $5`
	fi
#if 1   // added by yjpark.
	if [ -f "$FW_PATH/$FW_KERNEL_SLAVE" ]; then
		set -- `ls -l $FW_PATH/$FW_KERNEL_SLAVE`
		#echo "$FW_KERNEL_SLAVE size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_ROOTFS_SLAVE" ]; then
		set -- `ls -l $FW_PATH/$FW_ROOTFS_SLAVE`
		#echo "$FW_ROOTFS_SLAVE size $5 B"
		fsize=`expr $fsize + $5`
	fi
#endif
	if [ -f "$FW_PATH/$FW_PATCH" ]; then
		set -- `ls -l $FW_PATH/$FW_PATCH`
		#echo "$FW_PATCH size $5 B"
		fsize=`expr $fsize + $5`
	fi
#if 0   // blocked by mini.
#	if [ -f "$FW_PATH/$FW_LOGO" ]; then
#		set -- `ls -l $FW_PATH/$FW_LOGO`
#		#echo "$FW_LOGO size $5 B"
#		fsize=`expr $fsize + $5`
#	fi
#endif
	echo "$fsize"
}

html_info()
{
	echo "$1" >> $HTML_INFO
}

html_set_fw_size_remain()
{
	#print "Content-type: application/x-javascript\n\n" > $HTML_FW_SIZE_REMAIN
	echo "FWSizeRemain = $1;" > $HTML_FW_SIZE_REMAIN
}

#if 1   // added by yjpark.
html_result()
{ 
	echo "$1" > $HTML_RESULT
}
#endif

fail_out()
{
	# Remove temp files
	rm -f $FW_PATH/$FW_BOOT 2> /dev/null
	rm -f $FW_PATH/$FW_KERNEL 2> /dev/null
	rm -f $FW_PATH/$FW_ROOTFS 2> /dev/null
#if 1   // added by yjpark.
	rm -f $FW_PATH/$FW_KERNEL_SLAVE 2> /dev/null
	rm -f $FW_PATH/$FW_ROOTFS_SLAVE 2> /dev/null
#endif
	rm -f $FW_PATH/$FW_PATCH 2> /dev/null
	rm -f $FW_PATH/$FILE_FLAGS 2> /dev/null
	rm -f $FW_PATH/$FILE_THIS 2> /dev/null

#if 0   // modified by yjpark.
	#html_info "Programming FAILED!"

	#exit 1
#else
	if [ "$FW_BOOT" == "$1" ]; then
		html_info "Programming FAILED!!! = $1"
		html_result "FAILED"
	else
		html_info "Programming RETRY!!! = $1"
		html_result "RETRY"
	fi

	html_info "Failed to update $1, system reboot."

	astparam save
	sync

	sleep 3
	reboot
#endif
}

#if 1   // added by yjpark.
if [ "$BOOTM_JUMP" == "master" ]; then
#endif
	_p=`/usr/local/bin/io 0 1e6e207c`
	_IFS="$IFS";IFS=' ';set -- $_p;IFS="$_IFS"
	_p=$3
	case "$_p" in
		302)
			# AST1500
			SOC_VER='1'
		;;
		1000003 | 1010303 | 1010203 | 2010303)
			#1000003  AST1510 A0
			#1010303  AST1510 A1
			#1010203  AST1510 A1
			#2010303  AST1510 FPGA
			SOC_VER='2'
		;;
		2010003 | 4000003 | 4000303 | 4010303 | 4??1003)
			#2010003  AST1520 FPGA
			#4000003  AST1520 FPGA
			#4000303  AST1520 A0
			#4010303  AST2500 A1
			#4011003  AST1520 A1
			#4031003  AST1520 A2
			SOC_VER='3'
		;;
		*)
			html_info "Error!!! Unknown SoC version? $_p"
#if 0   // modified by yjpark.
			#fail_out
#else
			fail_out $UNKNOWN_SOC_VERSION
#endif
		;;
	esac

	if ! [ "$SOC_VER" = '3' ]; then
		html_info "Error! SoC version mismatch! ($SOC_VER)"
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $SOC_VERSION_MISMATCH
#endif
	fi
#if 1   // added by yjpark.
fi
#endif

# Check Platform
case "$AST_PLATFORM" in
	#New firmware uses 'ast1520-h-v1'.
	#We have to support both and check 'host'/'client'.
	ast1520-h-v?)
		html_info "Platform matched."
	;;
	*)
		html_info "Error! Platform mismatch!"
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $PLATFORM_MISMATCH 
#endif
esac

#if 1   // added by yjpark. modified by mini.
# if flash failed, booting slave by bootcount in next time.
BOOTCOUNT_LIMIT=`astparam r bootcount_limit`	# V22 bootloader

if echo "$BOOTCOUNT_LIMIT" | grep -q "not defined" ; then
	BOOTCOUNTLIMIT_MAX=`astparam r bootcountlimit_max`	# V21 bootloader

	if echo "$BOOTCOUNTLIMIT_MAX" | grep -q "not defined" ; then
		# for V20 bootloeader.
		V20_DEFAULT_BOOTCOUNTLIMIT_MAX=5
		BOOTCOUNTLIMIT=`expr $V20_DEFAULT_BOOTCOUNTLIMIT_MAX - 1`
	else
		BOOTCOUNTLIMIT=`expr $BOOTCOUNTLIMIT_MAX - 1`
	fi

	astparam w BOOTCOUNTLIMIT $BOOTCOUNTLIMIT
else
	BOOTCOUNT=`expr $BOOTCOUNT_LIMIT - 1`
	astparam w BOOTCOUNT $BOOTCOUNT
fi

astparam save ro
#endif

# ToDo. Check version.
# Start update
html_info "Start programming flash..."
if [ -f "$FW_BOOT" ]; then
	html_info "programming bootloader..."
	if ! [ -e /dev/"$FW_BOOT" ]; then
		mknod /dev/"$FW_BOOT" b 31 0
	fi
	if ! dd if="$FW_BOOT" of=/dev/"$FW_BOOT" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_BOOT
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "bootloader is done."
#endif
		rm -f "$FW_BOOT"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_KERNEL" ]; then
#if 0   // modified by mini.
	#html_info "programming kernel..."
#else
	html_info "programming master kernel..."
#endif
	if ! [ -e /dev/"$FW_KERNEL" ]; then
#if 0   // modified by yjpark.
		#mknod /dev/"$FW_KERNEL" b 31 1
#else
		mknod /dev/"$FW_KERNEL" b 31 5
#endif
	fi
	if ! dd if="$FW_KERNEL" of=/dev/"$FW_KERNEL" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_KERNEL
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "master kernel is done."
#endif
		rm -f "$FW_KERNEL"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_ROOTFS" ]; then
#if 0   // modified by mini.
	#html_info "programming rootfs..."
#else
	html_info "programming master rootfs..."
#endif
	if ! [ -e /dev/"$FW_ROOTFS" ]; then
#if 0   // modified by yjpark.
		#mknod /dev/"$FW_ROOTFS" b 31 2
#else
		mknod /dev/"$FW_ROOTFS" b 31 6
#endif
	fi
	if ! dd if="$FW_ROOTFS" of=/dev/"$FW_ROOTFS" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_ROOTFS
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "master rootfs is done."
#endif
		rm -f "$FW_ROOTFS"
	fi
fi
html_set_fw_size_remain `total_fw_size`
#if 1   // added by yjpark. modified by mini.
if [ -f "$FW_KERNEL_SLAVE" ]; then
	html_info "programming slave kernel..."
	if ! [ -e /dev/"$FW_KERNEL_SLAVE" ]; then
		mknod /dev/"$FW_KERNEL_SLAVE" b 31 7
	fi
	if ! dd if="$FW_KERNEL_SLAVE" of=/dev/"$FW_KERNEL_SLAVE" bs=64k; then
		fail_out $FW_KERNEL_SLAVE
	else
		html_info "slave kernel is done."
		rm -f "$FW_KERNEL_SLAVE"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_ROOTFS_SLAVE" ]; then
	html_info "programming slave rootfs..."
	if ! [ -e /dev/"$FW_ROOTFS_SLAVE" ]; then
		mknod /dev/"$FW_ROOTFS_SLAVE" b 31 8
	fi
	if ! dd if="$FW_ROOTFS_SLAVE" of=/dev/"$FW_ROOTFS_SLAVE" bs=64k; then
		fail_out $FW_ROOTFS_SLAVE
	else
		html_info "slave rootfs is done."
		rm -f "$FW_ROOTFS_SLAVE"
	fi
fi
#endif
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_PATCH" ]; then
	html_info "programming rootfs_patch..."
	if ! [ -e /dev/"$FW_PATCH" ]; then
#if 0   // modified by yjpark.
		#mknod /dev/"$FW_PATCH" b 31 3
#else
		mknod /dev/"$FW_PATCH" b 31 1
#endif
	fi
	if ! dd if="$FW_PATCH" of=/dev/"$FW_PATCH" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_PATCH
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "rootfs_patch is done."
#endif
		rm -f "$FW_PATCH"
	fi
fi
#if 0   // blocked by mini for HOST.
#html_set_fw_size_remain `total_fw_size`
#if [ -f "$FW_LOGO" ]; then
#	html_info "programming logo..."
#	if ! [ -e /dev/"$FW_LOGO" ]; then
#		mknod /dev/"$FW_LOGO" b 31 2
#	fi
#	if ! dd if="$FW_LOGO" of=/dev/"$FW_LOGO" bs=64k; then
#		fail_out
#	else
#		rm -f "$FW_LOGO"
#	fi
#fi
#endif
if [ -f "$FILE_FLAGS" ]; then
	html_info "programming parameters..."
	chmod a+x "$FILE_FLAGS"
	./"$FILE_FLAGS"
	rm -f "$FILE_FLAGS"
fi
if [ -f "$FW_EDID" ]; then
	html_info "programming EDID..."
	if [ -f "$SYSFS_EDID" ]; then
		cat "$FW_EDID" > "$SYSFS_EDID"
		rm -f "$FW_EDID"
	else
#if 0   // modified by yjpark, mini.
		#fail_out
#else
		html_info "EDID is done."
		fail_out $FW_EDID
#endif
	fi
fi

#if 1   // added by yjpark.
html_info "UPDATE_CUR_FW_VERSION: $UPDATE_CUR_FW_VERSION"
html_info "UPDATE_NEW_FW_VERSION: $UPDATE_NEW_FW_VERSION"

# WRITE: currently model_name, new model_version, new model_build_date.
writed_model_name_version_build_date

if [ "$CUR_FW_V10" != "" ]  && [ "$NEW_FW_V10" == "" ]; then
	html_info "When update to V1.4 or V1.5 to higher version than v2.0"
	update_from_v14_v15_to_higher_than_v20_restore_astparam
	update_from_v14_v15_to_higher_than_v20_set_save_astparam

	# old version compatibility (V10)
	astparam s bootm_jump master
	astparam save

	html_result "DONE"
	sleep 3

	# reboot now for V1.4 or V1.5.
	reboot
	exit 0
elif [ "$CUR_FW_V10" == "" ] && [ "$NEW_FW_V10" != "" ]; then
	if [ "$UPDATE_NEW_FW_VERSION" == "IPVDS-700-E_U404_V10_20180801" ]; then
		html_info "When update from version V2.0 or higher to vesion V10_20180801"
		update_from_V20_or_higher_to_v15_restore_astparam
		update_from_V20_or_higher_to_v15_set_save_astparam
	else
		html_info "When update from version V2.0 or higher to vesion V10_20180516"
		update_from_V20_or_higher_to_v14_restore_astparam
		update_from_V20_or_higher_to_v14_set_save_astparam
	fi
else
	html_info "When update to higher version than V2.0"
	update_to_higher_version_than_v20_restore_astparam
	update_to_higher_version_than_v20_set_save_astparam
fi

astparam s bootm_jump master
astparam save
#endif

html_set_fw_size_remain `total_fw_size`
html_info "Programming completed"
exit 0
