#!/bin/sh

HTML_INFO="/www/update_fw_info.txt"
HTML_FW_SIZE_REMAIN="/www/fw_size_remain.js"
#if 1   // added by yjpark.
HTML_RESULT="/www/update_fw_result.txt"
#endif

FW_PATH="/dev/shm"
FW_BOOT="mtdblkboot"
FW_KERNEL="mtdblkkernel"
FW_ROOTFS="mtdblkrootfs"
FW_PATCH="mtdblkrootfsp"
FW_LOGO="mtdblklogo"
FILE_FLAGS="flags.sh"
FILE_THIS="flash.sh"

#if 1   // added by yjpark for old version compatibility (V10, V20), modified by mini.
PLATFORM_MISMATCH="Platform mismatch."
SOC_VERSION_MISMATCH="SoC version mismatch."
UNKNOWN_SOC_VERSION="Unknown SoC version."

# GET current model version.
UPDATE_CUR_FW_VERSION=`cat /.version`

# Get Firmware info: CUR_MODEL_NAME, MODEL_VERSION, MODEL_BUILD_DATE.
CUR_MODEL_NAME=`cat /.version | awk -F'_' '{print $1}'`
_MODEL_VERSION=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $2}'`

if echo "$_MODEL_VERSION" | grep -q "V" ; then
	MODEL_VERSION=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $2}'`
	MODEL_BUILD_DATE=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $3}' | awk -F'.' '{print $1}'`
else
	MODEL_VERSION=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $3}'`
	MODEL_BUILD_DATE=`cat $HTML_INFO | grep "firmware file name" | awk -F' ' '{print $4}' | awk -F'_' '{print $4}' | awk -F'.' '{print $1}'`
fi

html_info "Current model_name: $CUR_MODEL_NAME"
html_info "New model_version: $MODEL_VERSION"
html_info "New model_build_date: $MODEL_BUILD_DATE"

if [ -f "/dev/shm/.version" ]; then
	# The file(.version) exists in version V20 below.
	UPDATE_NEW_FW_VERSION=`cat /dev/shm/.version`
else
	UPDATE_NEW_FW_VERSION="$CUR_MODEL_NAME"_"$MODEL_VERSION"_"$MODEL_BUILD_DATE"
fi

CUR_FW_V10=`echo "$UPDATE_CUR_FW_VERSION" | grep "V10"`
NEW_FW_V10=`echo "$UPDATE_NEW_FW_VERSION" | grep "V10"`

writed_model_name_version_build_date()
{
	# Read RO Astparam.
	GET_RO_ASTPARAM_MODEL_NAME=`astparam r model_name`
	GET_RO_ASTPARAM_MODEL_VERSION=`astparam r model_version`
	GET_RO_ASTPARAM_MODEL_BUILD_DATE=`astparam r model_build_date`
	html_info "RO model_name: $GET_RO_ASTPARAM_MODEL_NAME"
	html_info "Old RO model_version: $GET_RO_ASTPARAM_MODEL_VERSION"
	html_info "Old RO model_build_date: $GET_RO_ASTPARAM_MODEL_BUILD_DATE"

	if echo "$CUR_MODEL_NAME" | grep -q "IPVDS-500-D" ||
	   echo "$CUR_MODEL_NAME" | grep -q "S600-OP-D"; then
		html_info "CUR_MODEL_NAME: $CUR_MODEL_NAME"
	else
		html_info "Write a model_name not matched $CUR_MODEL_NAME"
	fi
	astparam w model_name $CUR_MODEL_NAME

	html_info "New RO model_version: $MODEL_VERSION"
	html_info "New RO model_build_date: $MODEL_BUILD_DATE"
	astparam w model_version $MODEL_VERSION
	astparam w model_build_date $MODEL_BUILD_DATE
	astparam save ro
}

added_V21_restore_astparam()
{
	RESTORE_NO_KMOIP=`astparam g no_kmoip`
	if echo "$RESTORE_NO_KMOIP" | grep -q "not defined" ; then
		RESTORE_NO_KMOIP=""
	fi

	RESTORE_V_OUTPUT_TIMING_CONVERT=`astparam g v_output_timing_convert`
	if echo "$RESTORE_V_OUTPUT_TIMING_CONVERT" | grep -q "not defined" ; then
		RESTORE_V_OUTPUT_TIMING_CONVERT=""
	fi

	RESTORE_VW_VAR_STRETCH_TYPE=`astparam g vw_var_stretch_type`
	if echo "$RESTORE_VW_VAR_STRETCH_TYPE" | grep -q "not defined" ; then
		RESTORE_VW_VAR_STRETCH_TYPE=""
	fi

	RESTORE_VW_STRETCH_TYPE=`astparam g vw_stretch_type`
	if echo "$RESTORE_VW_STRETCH_TYPE" | grep -q "not defined" ; then
		RESTORE_VW_STRETCH_TYPE=""
	fi

	RESTORE_SOIP_GUEST_ON=`astparam g soip_guest_on`
	if echo "$RESTORE_SOIP_GUEST_ON" | grep -q "not defined" ; then
		RESTORE_SOIP_GUEST_ON=""
	fi

	RESTORE_S0_BAUDRATE=`astparam g s0_baudrate`
	if echo "$RESTORE_S0_BAUDRATE" | grep -q "not defined" ; then
		RESTORE_S0_BAUDRATE=""
	fi
}

added_V21_set_save_astparam()
{
	astparam s no_kmoip $RESTORE_NO_KMOIP
	astparam s v_output_timing_convert $RESTORE_V_OUTPUT_TIMING_CONVERT
	astparam s vw_var_stretch_type $RESTORE_VW_VAR_STRETCH_TYPE
	astparam s vw_stretch_type $RESTORE_VW_STRETCH_TYPE
	astparam s soip_guest_on $RESTORE_SOIP_GUEST_ON
	astparam s s0_baudrate $RESTORE_S0_BAUDRATE
}

added_V22_restore_astparam()
{
	return
}

added_V22_set_save_astparam()
{
	return
}

common_restore_astparam()
{
	RESTORE_SERIAL_NUMBER=`astparam g serial_number`
	RESTORE_ETHADDR=`astparam g ethaddr`
	RESTORE_IP_MODE=`astparam g ip_mode`
	RESTORE_IPADDR=`astparam g ipaddr`
	RESTORE_NETMASK=`astparam g netmask`
	RESTORE_GATEWAYIP=`astparam g gatewayip`
	RESTORE_HOSTNAME_ID=`astparam g hostname_id`
	RESTORE_JUMBO_MTU=`astparam g jumbo_mtu`
	RESTORE_UI_DEFAULT_RES=`astparam g ui_default_res`
}

common_set_save_astparam()
{
	astparam s multicast_on y
	astparam s en_video_wall y
	astparam s hostnamebydipswitch n
	astparam s hdcp_always_on y
	astparam s web_ui_cfg nevwausr
	astparam s a_io_select auto
	astparam s reset_ch_on_boot n
	astparam s osd y
	astparam s ui_feature y
	astparam s usb_disable_classes hid
	astparam s v_eng_drv_option 0x0001000
	astparam s v_turn_off_screen_on_pwr_save n
	astparam s v_src_unavailable_timeout 1000
	astparam s v_pwr_save_timeout 1000

	astparam s serial_number $RESTORE_SERIAL_NUMBER
	astparam s ethaddr $RESTORE_ETHADDR
	astparam s ip_mode $RESTORE_IP_MODE
	astparam s ipaddr $RESTORE_IPADDR
	astparam s netmask $RESTORE_NETMASK
	astparam s gatewayip $RESTORE_GATEWAYIP
	astparam s hostname_id $RESTORE_HOSTNAME_ID
	astparam s jumbo_mtu $RESTORE_JUMBO_MTU
	astparam s ui_default_res $RESTORE_UI_DEFAULT_RES
}

update_from_V20_or_higher_to_v14_restore_astparam()
{
	common_restore_astparam

#if 1   // V1.4 default
	RESTORE_NO_I2S='n'
	RESTORE_BLOCKING='y'
	RESTORE_SHARE_USB_AUTO_MODE='n'
	RESTORE_NO_USB='n'
	RESTORE_NO_KMOIP='y'
	RESTORE_NO_IR='y'
	RESTORE_KMOIP_TOKEN_INTERVAL='3000'
#endif

#if 1   // convert V2.0 to V1.4
	# V2.0 = rs232_port_selection
	# V1.4 = serial_debug_sel
	RESTORE_RS232_PORT_SELECTION=`astparam g rs232_port_selection`
	if echo "$RESTORE_RS232_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=""
	fi

	# V2.0 = ir_port_selection
	# V1.4 = ir_tx_rx_sel
	RESTORE_IR_PORT_SELECTION=`astparam g ir_port_selection`
	if echo "$RESTORE_IR_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=""
	fi

	RESTORE_ENABLE_HPD=`astparam g enable_hpd`
	if echo "$RESTORE_ENABLE_HPD" | grep -q "not defined" ; then
		RESTORE_ENABLE_HPD=""
	fi

	RESTORE_DELAY_AFTER_HPD=`astparam g delay_after_hpd`
	if echo "$RESTORE_DELAY_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_DELAY_AFTER_HPD=""
	fi

	RESTORE_RESET_TMDS_AFTER_HPD=`astparam g reset_tmds_after_hpd`
	if echo "$RESTORE_RESET_TMDS_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_RESET_TMDS_AFTER_HPD=""
	fi

	RESTORE_ENABLE_GENLOCK=`astparam g enable_genlock`
	if echo "$RESTORE_ENABLE_GENLOCK" | grep -q "not defined" ; then
		RESTORE_ENABLE_GENLOCK=""
	fi

	RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=`astparam g delay_before_turns_on_display_after_hpd`
	if echo "$RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=""
	fi
#endif
}

update_from_V20_or_higher_to_v14_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

#if 1   // V1.4 default
	astparam s no_i2s $RESTORE_NO_I2S
	astparam s blocking $RESTORE_BLOCKING
	astparam s share_usb_auto_mode $RESTORE_SHARE_USB_AUTO_MODE
	astparam s no_usb $RESTORE_NO_USB
	astparam s no_kmoip $RESTORE_NO_KMOIP
	astparam s no_ir $RESTORE_NO_IR
	astparam s kmoip_token_interval $RESTORE_KMOIP_TOKEN_INTERVAL
#endif

#if 1   // convert V2.0 to V1.4
	astparam s serial_debug_sel $RESTORE_RS232_PORT_SELECTION
	astparam s ir_tx_rx_sel $RESTORE_IR_PORT_SELECTION
	astparam s hpd_ignore $RESTORE_ENABLE_HPD
	astparam s hpd_sleep_time $RESTORE_DELAY_AFTER_HPD
	astparam s tmds_disable $RESTORE_RESET_TMDS_AFTER_HPD
	astparam s gen_lock_disable $RESTORE_ENABLE_GENLOCK
	astparam s hpd_screen_onoff_time $RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD
#endif

	astparam save
	sync
}

update_from_V20_or_higher_to_v15_restore_astparam()
{
	common_restore_astparam

	RESTORE_RS232_PORT_SELECTION=`astparam g rs232_port_selection`
	if echo "$RESTORE_RS232_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=""
	fi

	RESTORE_IR_PORT_SELECTION=`astparam g ir_port_selection`
	if echo "$RESTORE_IR_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=""
	fi

	RESTORE_ENABLE_HPD=`astparam g enable_hpd`
	if echo "$RESTORE_ENABLE_HPD" | grep -q "not defined" ; then
		RESTORE_ENABLE_HPD=""
	fi

	RESTORE_DELAY_AFTER_HPD=`astparam g delay_after_hpd`
	if echo "$RESTORE_DELAY_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_DELAY_AFTER_HPD=""
	fi

	RESTORE_RESET_TMDS_AFTER_HPD=`astparam g reset_tmds_after_hpd`
	if echo "$RESTORE_RESET_TMDS_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_RESET_TMDS_AFTER_HPD=""
	fi

	RESTORE_ENABLE_GENLOCK=`astparam g enable_genlock`
	if echo "$RESTORE_ENABLE_GENLOCK" | grep -q "not defined" ; then
		RESTORE_ENABLE_GENLOCK=""
	fi

	RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED=`astparam g enable_display_power_saving_after_encoder_disconnected`
	if echo "$RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED" | grep -q "not defined" ; then
		RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED=""
	fi

	RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING=`astparam g delay_before_display_goes_to_power_saving`
	if echo "$RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING" | grep -q "not defined" ; then
		RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING=""
	fi

	RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING=`astparam g show_logo_instead_of_power_saving`
	if echo "$RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING" | grep -q "not defined" ; then
		RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING=""
	fi

#if 1   // V1.5 default
	RESTORE_NO_I2S='n'
	RESTORE_BLOCKING='n'
	RESTORE_SHARE_USB_AUTO_MODE='n'
	RESTORE_NO_USB='n'
	RESTORE_NO_KMOIP='y'
	RESTORE_NO_IR='y'
	RESTORE_KMOIP_TOKEN_INTERVAL='3000'
#endif

#if 1   // convert V2.0 to V1.5
	# V2.0 = delay_before_turns_on_display_after_hpd
	# V1.5 = delay_before_display_turns_on_after_hpd
	RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=`astparam g delay_before_turns_on_display_after_hpd`
#endif
}

update_from_V20_or_higher_to_v15_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

	astparam s rs232_port_selection $RESTORE_RS232_PORT_SELECTION
	astparam s ir_port_selection $RESTORE_IR_PORT_SELECTION

	astparam s enable_hpd $RESTORE_ENABLE_HPD
	astparam s delay_after_hpd $RESTORE_DELAY_AFTER_HPD
	astparam s reset_tmds_after_hpd $RESTORE_RESET_TMDS_AFTER_HPD
	astparam s enable_genlock $RESTORE_ENABLE_GENLOCK
	astparam s enable_display_power_saving_after_encoder_disconnected $RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED
	astparam s delay_before_display_goes_to_power_saving $RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING
	astparam s show_logo_instead_of_power_saving $RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING

#if 1   // V1.5 default
	astparam s no_i2s $RESTORE_NO_I2S
	astparam s blocking $RESTORE_BLOCKING
	astparam s share_usb_auto_mode $RESTORE_SHARE_USB_AUTO_MODE
	astparam s no_usb $RESTORE_NO_USB
	astparam s no_kmoip $RESTORE_NO_KMOIP
	astparam s no_ir $RESTORE_NO_IR
	astparam s kmoip_token_interval $RESTORE_KMOIP_TOKEN_INTERVAL
#endif

#if 1   // convert V2.0 to V1.5
	# V2.0 = delay_before_turns_on_display_after_hpd
	# V1.5 = delay_before_display_turns_on_after_hpd
	astparam s delay_before_display_turns_on_after_hpd $RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD
#endif

	astparam save
	sync
}

update_from_v14_v15_to_higher_than_v20_restore_astparam()
{
	common_restore_astparam
	added_V21_restore_astparam
	added_V22_restore_astparam

#if 1   // V2.0 default
	RESTORE_ANALOG_AUDIO_VOLUME='87'
	RESTORE_AUDIO_MUTE='y'
	RESTORE_ENABLE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING='n'
	RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING='5'
#endif

#if 1   // convert V1.4 or V1.5 to V2.0
	RS232_PORT_SELECTION_V1_5=`astparam g rs232_port_selection`
	RS232_PORT_SELECTION_V1_4=`astparam g serial_debug_sel`
	if echo "$RS232_PORT_SELECTION_V1_5" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=$RS232_PORT_SELECTION_V1_4
	else
		RESTORE_RS232_PORT_SELECTION=$RS232_PORT_SELECTION_V1_5
	fi

	IR_PORT_SELECTION_V1_5=`astparam g ir_port_selection`
	IR_PORT_SELECTION_V1_4=`astparam g ir_tx_rx_sel`
	if echo "$IR_PORT_SELECTION_V1_5" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=$IR_PORT_SELECTION_V1_4
	else
		RESTORE_IR_PORT_SELECTION=$IR_PORT_SELECTION_V1_5
	fi

	ENABLE_HPD_V1_5=`astparam g enable_hpd`
	ENABLE_HPD_V1_4=`astparam g hpd_ignore`
	if echo "$ENABLE_HPD_V1_5" | grep -q "not defined" ; then
		RESTORE_ENABLE_HPD=$ENABLE_HPD_V1_4
	else
		RESTORE_ENABLE_HPD=$ENABLE_HPD_V1_5
	fi

	DELAY_AFTER_HPD_V1_5=`astparam g delay_after_hpd`
	DELAY_AFTER_HPD_V1_4=`astparam g hpd_sleep_time`
	if echo "$DELAY_AFTER_HPD_V1_5" | grep -q "not defined" ; then
		RESTORE_DELAY_AFTER_HPD=$DELAY_AFTER_HPD_V1_4
	else
		RESTORE_DELAY_AFTER_HPD=$DELAY_AFTER_HPD_V1_5
	fi

	RESET_TMDS_AFTER_HPD_V1_5=`astparam g reset_tmds_after_hpd`
	RESET_TMDS_AFTER_HPD_V1_4=`astparam g tmds_disable`
	if echo "$RESET_TMDS_AFTER_HPD_V1_5" | grep -q "not defined" ; then
		RESTORE_RESET_TMDS_AFTER_HPD=$RESET_TMDS_AFTER_HPD_V1_4
	else
		RESTORE_RESET_TMDS_AFTER_HPD=$RESET_TMDS_AFTER_HPD_V1_5
	fi

	# V2.0 = delay_before_turns_on_display_after_hpd
	# V1.5 = delay_before_display_turns_on_after_hpd
	# V1.4 = hpd_screen_onoff_time
	DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD_1_5=`astparam g delay_before_display_turns_on_after_hpd`
	DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD_1_4=`astparam g hpd_screen_onoff_time`
	if echo "$DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD_1_5" | grep -q "not defined" ; then
		RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=$DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD_1_4
	else
		RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=$DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD_1_5
	fi

	ENABLE_GENLOCK_V1_5=`astparam g enable_genlock`
	ENABLE_GENLOCK_V1_4=`astparam g gen_lock_disable`
	if echo "$ENABLE_GENLOCK_V1_5" | grep -q "not defined" ; then
		RESTORE_ENABLE_GENLOCK=$ENABLE_GENLOCK_V1_4
	else
		RESTORE_ENABLE_GENLOCK=$ENABLE_GENLOCK_V1_5
	fi

	# enable_display_power_saving_after_encoder_disconnected does not exist in V1.4.
	ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED_V1_5=`astparam g enable_display_power_saving_after_encoder_disconnected`
	if echo "$ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED_V1_5" | grep -q "not defined" ; then
		# V2.0 Default value
		RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED='0'
	else
		RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED=$ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED_V1_5
	fi

	# delay_before_display_goes_to_power_saving does not exist in V1.4.
	DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING_V1_5=`astparam g delay_before_display_goes_to_power_saving`
	if echo "$DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING_V1_5" | grep -q "not defined" ; then
		# V2.0 Default value
		RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING='30'
	else
		RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING=$DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING_V1_5
	fi

	# show_logo_instead_of_power_saving does not exist in V1.4.
	SHOW_LOGO_INSTEAD_OF_POWER_SAVING_V1_5=`astparam g show_logo_instead_of_power_saving`
	if echo "$SHOW_LOGO_INSTEAD_OF_POWER_SAVING_V1_5" | grep -q "not defined" ; then
		# V2.0 Default value
		RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING='n'
	else
		RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING=$SHOW_LOGO_INSTEAD_OF_POWER_SAVING_V1_5
	fi
#endif
}

update_from_v14_v15_to_higher_than_v20_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

#if 1   // V2.0 default
	astparam s analog_audio_volume $RESTORE_ANALOG_AUDIO_VOLUME
	astparam s audio_mute $RESTORE_AUDIO_MUTE
	astparam s enable_turns_on_display_again_when_get_out_of_power_saving $RESTORE_ENABLE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING
	astparam s delay_before_turns_on_display_again_when_get_out_of_power_saving $RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING
#endif

#if 1   // V2.0 default
	astparam s rs232_port_selection $RESTORE_RS232_PORT_SELECTION
	astparam s ir_port_selection $RESTORE_IR_PORT_SELECTION
	astparam s enable_hpd $RESTORE_ENABLE_HPD
	astparam s delay_after_hpd $RESTORE_DELAY_AFTER_HPD
	astparam s reset_tmds_after_hpd $RESTORE_RESET_TMDS_AFTER_HPD

	# V2.0 = delay_before_turns_on_display_after_hpd
	# V1.5 = delay_before_display_turns_on_after_hpd
	# V1.4 = hpd_screen_onoff_time
	astparam s delay_before_turns_on_display_after_hpd $RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD
	astparam s enable_genlock $RESTORE_ENABLE_GENLOCK

	astparam s enable_display_power_saving_after_encoder_disconnected $RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED
	astparam s delay_before_display_goes_to_power_saving $RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING
	astparam s show_logo_instead_of_power_saving $RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING
#endif

	added_V21_set_save_astparam
	added_V22_set_save_astparam

	astparam save
	sync
}

update_to_higher_version_than_v20_restore_astparam()
{
	common_restore_astparam
	added_V21_restore_astparam
	added_V22_restore_astparam

	RESTORE_TELNET=`astparam g telnetd_param`
	if echo "$RESTORE_TELNET" | grep -q "not defined" ; then
		RESTORE_TELNET=""
	fi

	RESTORE_RS232_PORT_SELECTION=`astparam g rs232_port_selection`
	if echo "$RESTORE_RS232_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_RS232_PORT_SELECTION=""
	fi

	RESTORE_IR_PORT_SELECTION=`astparam g ir_port_selection`
	if echo "$RESTORE_IR_PORT_SELECTION" | grep -q "not defined" ; then
		RESTORE_IR_PORT_SELECTION=""
	fi

	RESTORE_AUDIO_MUTE=`astparam g audio_mute`
	if echo "$RESTORE_AUDIO_MUTE" | grep -q "not defined" ; then
		RESTORE_AUDIO_MUTE=""
	fi

	RESTORE_ANALOG_AUDIO_VOLUME=`astparam g analog_audio_volume`
	if echo "$RESTORE_ANALOG_AUDIO_VOLUME" | grep -q "not defined" ; then
		RESTORE_ANALOG_AUDIO_VOLUME=""
	fi

	RESTORE_ENABLE_HPD=`astparam g enable_hpd`
	if echo "$RESTORE_ENABLE_HPD" | grep -q "not defined" ; then
		RESTORE_ENABLE_HPD=""
	fi

	RESTORE_DELAY_AFTER_HPD=`astparam g delay_after_hpd`
	if echo "$RESTORE_DELAY_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_DELAY_AFTER_HPD=""
	fi

	RESTORE_RESET_TMDS_AFTER_HPD=`astparam g reset_tmds_after_hpd`
	if echo "$RESTORE_RESET_TMDS_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_RESET_TMDS_AFTER_HPD=""
	fi

	RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=`astparam g delay_before_turns_on_display_after_hpd`
	if echo "$RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD" | grep -q "not defined" ; then
		RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD=""
	fi

	RESTORE_ENABLE_GENLOCK=`astparam g enable_genlock`
	if echo "$RESTORE_ENABLE_GENLOCK" | grep -q "not defined" ; then
		RESTORE_ENABLE_GENLOCK=""
	fi

	RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED=`astparam g enable_display_power_saving_after_encoder_disconnected`
	if echo "$RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED" | grep -q "not defined" ; then
		RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED=""
	fi

	RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING=`astparam g delay_before_display_goes_to_power_saving`
	if echo "$RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING" | grep -q "not defined" ; then
		RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING=""
	fi

	RESTORE_ENABLE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING=`astparam g enable_turns_on_display_again_when_get_out_of_power_saving`
	if echo "$RESTORE_ENABLE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING" | grep -q "not defined" ; then
		RESTORE_ENABLE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING=""
	fi

	RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING=`astparam g delay_before_turns_on_display_again_when_get_out_of_power_saving`
	if echo "$RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING" | grep -q "not defined" ; then
		RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING=""
	fi

	RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING=`astparam g show_logo_instead_of_power_saving`
	if echo "$RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING" | grep -q "not defined" ; then
		RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING=""
	fi
}

update_to_higher_version_than_v20_set_save_astparam()
{
	astparam flush
	sleep 3
	astparam flush
	sleep 3

	common_set_save_astparam

	astparam s telnetd_param $RESTORE_TELNET
	astparam s rs232_port_selection $RESTORE_RS232_PORT_SELECTION
	astparam s ir_port_selection $RESTORE_IR_PORT_SELECTION

	astparam s audio_mute $RESTORE_AUDIO_MUTE
	astparam s analog_audio_volume $RESTORE_ANALOG_AUDIO_VOLUME
	astparam s enable_hpd $RESTORE_ENABLE_HPD
	astparam s delay_after_hpd $RESTORE_DELAY_AFTER_HPD
	astparam s reset_tmds_after_hpd $RESTORE_RESET_TMDS_AFTER_HPD
	astparam s delay_before_turns_on_display_after_hpd $RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AFTER_HPD
	astparam s enable_genlock $RESTORE_ENABLE_GENLOCK
	astparam s enable_display_power_saving_after_encoder_disconnected $RESTORE_ENABLE_DISPLAY_POWER_SAVING_AFTER_ENCODER_DISCONNECTED
	astparam s delay_before_display_goes_to_power_saving $RESTORE_DELAY_BEFORE_DISPLAY_GOES_TO_POWER_SAVING
	astparam s enable_turns_on_display_again_when_get_out_of_power_saving $RESTORE_ENABLE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING
	astparam s delay_before_turns_on_display_again_when_get_out_of_power_saving $RESTORE_DELAY_BEFORE_TURNS_ON_DISPLAY_AGAIN_WHEN_GET_OUT_OF_POWER_SAVING
	astparam s show_logo_instead_of_power_saving $RESTORE_SHOW_LOGO_INSTEAD_OF_POWER_SAVING

	added_V21_set_save_astparam
	added_V22_set_save_astparam

	astparam save
	sync
}
#endif

total_fw_size()
{
	fsize='0'
	if [ -f "$FW_PATH/$FW_BOOT" ]; then
		set -- `ls -l $FW_PATH/$FW_BOOT`
		#echo "$FW_BOOT size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_KERNEL" ]; then
		set -- `ls -l $FW_PATH/$FW_KERNEL`
		#echo "$FW_KERNEL size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_ROOTFS" ]; then
		set -- `ls -l $FW_PATH/$FW_ROOTFS`
		#echo "$FW_ROOTFS size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_PATCH" ]; then
		set -- `ls -l $FW_PATH/$FW_PATCH`
		#echo "$FW_PATCH size $5 B"
		fsize=`expr $fsize + $5`
	fi
	if [ -f "$FW_PATH/$FW_LOGO" ]; then
		set -- `ls -l $FW_PATH/$FW_LOGO`
		#echo "$FW_LOGO size $5 B"
		fsize=`expr $fsize + $5`
	fi
	echo "$fsize"
}

html_info()
{
	echo "$1" >> $HTML_INFO
}

html_set_fw_size_remain()
{
	#print "Content-type: application/x-javascript\n\n" > $HTML_FW_SIZE_REMAIN
	echo "FWSizeRemain = $1;" > $HTML_FW_SIZE_REMAIN
}

#if 1   // added by yjpark.
html_result()
{ 
	echo "$1" > $HTML_RESULT
}
#endif

fail_out()
{
	# Remove temp files
	rm -f $FW_PATH/$FW_BOOT 2> /dev/null
	rm -f $FW_PATH/$FW_KERNEL 2> /dev/null
	rm -f $FW_PATH/$FW_ROOTFS 2> /dev/null
	rm -f $FW_PATH/$FW_PATCH 2> /dev/null
	rm -f $FW_PATH/$FW_LOGO 2> /dev/null
	rm -f $FW_PATH/$FILE_FLAGS 2> /dev/null
	rm -f $FW_PATH/$FILE_THIS 2> /dev/null

#if 0   // modified by yjpark.
	#html_info "Programming FAILED!"

	#exit 1
#else
	if [ "$FW_BOOT" == "$1" ]; then
		html_info "Programming FAILED!!! = $1"
		html_result "FAILED"
	else
		html_info "Programming RETRY!!! = $1"
		html_result "RETRY"
	fi

	html_info "Failed to update $1, system reboot."

	astparam save
	sync

	sleep 3
	reboot
#endif
}

_p=`/usr/local/bin/io 0 1e6e207c`
_IFS="$IFS";IFS=' ';set -- $_p;IFS="$_IFS"
_p=$3
case "$_p" in
	302)
		# AST1500
		SOC_VER='1'
	;;
	1000003 | 1010303 | 1010203 | 2010303)
		#1000003  AST1510 A0
		#1010303  AST1510 A1
		#1010203  AST1510 A1
		#2010303  AST1510 FPGA
		SOC_VER='2'
	;;
	2010003 | 4000003 | 4000303 | 4010303 | 4??1003)
		#2010003  AST1520 FPGA
		#4000003  AST1520 FPGA
		#4000303  AST1520 A0
		#4010303  AST2500 A1
		#4011003  AST1520 A1
		#4031003  AST1520 A2
		SOC_VER='3'
	;;
	*)
		html_info "Error!!! Unknown SoC version? $_p"
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $UNKNOWN_SOC_VERSION
#endif
	;;
esac

if ! [ "$SOC_VER" = '3' ]; then
	html_info "Error! SoC version mismatch! ($SOC_VER)"
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $SOC_VERSION_MISMATCH
#endif
fi

# Check Platform
case "$AST_PLATFORM" in
	#New firmware uses 'ast1520-c-v1'.
	#We have to support both and check 'host'/'client'.
	ast1520-c-v?)
		html_info "Platform matched."
	;;
	*)
		html_info "Error! Platform mismatch!"
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $PLATFORM_MISMATCH 
#endif
esac

# Start update
html_info "Start programming flash..."
if [ -f "$FW_BOOT" ]; then
	html_info "programming bootloader..."
	if ! [ -e /dev/"$FW_BOOT" ]; then
		mknod /dev/"$FW_BOOT" b 31 0
	fi
	if ! dd if="$FW_BOOT" of=/dev/"$FW_BOOT" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_BOOT
#endif
	else
#if 1   // added by yjpark.
		html_info "bootloader is done."
#endif
		rm -f "$FW_BOOT"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_KERNEL" ]; then
	html_info "programming kernel..."
	if ! [ -e /dev/"$FW_KERNEL" ]; then
		mknod /dev/"$FW_KERNEL" b 31 5
	fi
	if ! dd if="$FW_KERNEL" of=/dev/"$FW_KERNEL" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_KERNEL
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "kernel is done."
#enedif
		rm -f "$FW_KERNEL"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_ROOTFS" ]; then
	html_info "programming rootfs..."
	if ! [ -e /dev/"$FW_ROOTFS" ]; then
		mknod /dev/"$FW_ROOTFS" b 31 6
	fi
	if ! dd if="$FW_ROOTFS" of=/dev/"$FW_ROOTFS" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_ROOTFS
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "rootfs is done."
#endif
		rm -f "$FW_ROOTFS"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_PATCH" ]; then
	html_info "programming rootfs_patch..."
	if ! [ -e /dev/"$FW_PATCH" ]; then
		mknod /dev/"$FW_PATCH" b 31 1
	fi
	if ! dd if="$FW_PATCH" of=/dev/"$FW_PATCH" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_PATCH
#endif
	else
#if 1   // added by yjpark. modified by mini.
		html_info "rootfs_patch is done."
#endif
		rm -f "$FW_PATCH"
	fi
fi
html_set_fw_size_remain `total_fw_size`
if [ -f "$FW_LOGO" ]; then
	html_info "programming logo..."
	if ! [ -e /dev/"$FW_LOGO" ]; then
		mknod /dev/"$FW_LOGO" b 31 2
	fi
	if ! dd if="$FW_LOGO" of=/dev/"$FW_LOGO" bs=64k; then
#if 0   // modified by yjpark.
		#fail_out
#else
		fail_out $FW_LOGO
#endif
	else
#if 1   // added by yjpark.
		html_info "logo is done."
#endif
		rm -f "$FW_LOGO"
	fi
fi
if [ -f "$FILE_FLAGS" ]; then
	html_info "programming parameters..."
	chmod a+x "$FILE_FLAGS"
	./"$FILE_FLAGS"
	rm -f "$FILE_FLAGS"
fi

#if 1   // added by yjpark.
html_info "UPDATE_CUR_FW_VERSION: $UPDATE_CUR_FW_VERSION"
html_info "UPDATE_NEW_FW_VERSION: $UPDATE_NEW_FW_VERSION"

# WRITE: currently model_name, new model_version, new model_build_date.
writed_model_name_version_build_date

if [ "$CUR_FW_V10" != "" ]  && [ "$NEW_FW_V10" == "" ]; then
	html_info "When update from V1.4 or V1.5 to higher version than v2.0"
	update_from_v14_v15_to_higher_than_v20_restore_astparam
	update_from_v14_v15_to_higher_than_v20_set_save_astparam

	# old version compatibility (V10)
	astparam s bootm_jump master
	astparam save

	html_result "DONE. Rebooting..."
	sleep 3

	# reboot now for V1.4 or V1.5.
	reboot
	exit 0
elif [ "$CUR_FW_V10" == "" ] && [ "$NEW_FW_V10" != "" ]; then
	if [ "$UPDATE_NEW_FW_VERSION" == "IPVDS-700-D_U4004_V10_20180801" ]; then
		html_info "When update from version V2.0 or higher to vesion V10_20180801"
		update_from_V20_or_higher_to_v15_restore_astparam
		update_from_V20_or_higher_to_v15_set_save_astparam
	else
		html_info "When update from version V2.0 or higher to vesion V10_20180516"
		update_from_V20_or_higher_to_v14_restore_astparam
		update_from_V20_or_higher_to_v14_set_save_astparam
	fi
else
	html_info "When update to higher version than V2.0"
	update_to_higher_version_than_v20_restore_astparam
	update_to_higher_version_than_v20_set_save_astparam
fi

if echo "$CUR_MODEL_NAME" | grep -q "S600-OP-D" ; then
	astparam s no_usb y
	astparam s no_kmoip y
fi

astparam s bootm_jump master
astparam save
#endif

html_set_fw_size_remain `total_fw_size`
html_info "Programming completed"
exit 0
